/*
 * QrfeCache.h
 *
 *  Created on: 16.02.2011
 *      Author: stefan.detter
 */

#ifndef QRFECACHE_H_
#define QRFECACHE_H_

#include <QMap>
#include <QVariant>

class QSettings;

class QrfeCache
{
public:
	QrfeCache();
	~QrfeCache();

	static QrfeCache 	d;

	void 		init ( QString appName );

	QVariant 	value ( QString key, const QVariant& defaultValue = QVariant() );
	void 		setValue ( QString key, const QVariant& value );

private:
	bool 					m_init;
	QMap<QString, QVariant> m_cache;
	QSettings* 				m_settings;
};

#endif /* QRFECACHE_H_ */
